//+------------------------------------------------------------------+
//|                                            OutputIndicators2.mq4 |
//|                                   Copyright (c) 2009, Toyolab FX |
//|                                         http://forex.toyolab.com |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2009, Toyolab FX"
#property link      "http://forex.toyolab.com/"
#property indicator_chart_window

// Op[^
extern datetime StartTime; // Jn

// t@Co͊֐
void WriteIndicators(int handle, int i)
{
   string sDate = TimeYear(Time[i]) + "/" + TimeMonth(Time[i]) + "/" + TimeDay(Time[i]);
   string sTime = TimeHour(Time[i]) + ":" + TimeMinute(Time[i]);
   double ma200 = iMA(NULL, 0, 200, 0, MODE_SMA, PRICE_CLOSE, i);
   FileWrite(handle, sDate, sTime, Open[i], High[i], Low[i], Close[i], ma200);
}

// ֐
int init()
{
   // t@CI[v
   int handle = FileOpen(Symbol()+Period()+".csv", FILE_CSV|FILE_WRITE, ',');
   if(handle < 0) return(-1);

   // t@Co
   FileWrite(handle, "Date", "Time", "Open", "High", "Low", "Close", "MA200");
   int iStart = iBarShift(NULL, 0, StartTime);
   for(int i=iStart; i>=1; i--) WriteIndicators(handle, i);
   
   // t@CN[Y
   FileClose(handle);

   return(0);
}

// X^[g֐
int start()
{
   if(Volume[0]>1) return(0);

   // t@CI[v
   int handle = FileOpen(Symbol()+Period()+".csv", FILE_CSV|FILE_READ|FILE_WRITE, ',');
   if(handle < 0) return(-1);

   // ǉ݂̂߂̏
   FileSeek(handle, 0, SEEK_END);
   
   // t@Co
   WriteIndicators(handle, 1);
   
   // t@CN[Y
   FileClose(handle);

   return(0);
}

