//+------------------------------------------------------------------+
//|                                                       RSI1F1.mq4 |
//|                                   Copyright (c) 2009, Toyolab FX |
//|                                         http://forex.toyolab.com |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2009, Toyolab FX"
#property link      "http://forex.toyolab.com"

// }CCu[
#include <MyLib.mqh>

// }WbNio[
#define MAGIC  20094023
#define COMMENT "RSI1F1"

// Op[^
extern double Lots = 0.1;
extern int Slippage = 3;

// Gg[֐
extern int RSIPeriod = 14; // RSI̊
int EntrySignal(int magic)
{
   // I[v|WV̌vZ
   double pos = MyCurrentOrders(MY_OPENPOS, magic);

   // RSǏvZ
   double rsi1 = iRSI(Symbol(), 0, RSIPeriod, PRICE_CLOSE, 1);

   int ret = 0;
   // VOi
   if(pos <= 0 && rsi1 < 30) ret = 1;
   // VOi
   if(pos >= 0 && rsi1 > 70) ret = -1;

   return(ret);
}

// tB^[֐
extern string StartTime = "9:30";   // Jn
extern string EndTime = "12:30";    // I
int FilterSignal(int signal)
{
   string sdate = TimeToStr(TimeCurrent(), TIME_DATE);
   datetime start_time = StrToTime(sdate+" "+StartTime);
   datetime end_time = StrToTime(sdate+" "+EndTime);

   int ret = 0;
   if(start_time <= end_time)
   {
      if(TimeCurrent() >= start_time && TimeCurrent() < end_time) ret = signal;
      else ret = 0;
   }
   else
   {
      if(TimeCurrent() >= end_time && TimeCurrent() < start_time) ret = 0;
      else ret = signal;
   }

   return(ret);
}

// GOWbg֐
void ExitPosition(int magic)
{
   string sdate = TimeToStr(TimeCurrent(), TIME_DATE);
   datetime end_time = StrToTime(sdate+" "+EndTime);

   if(TimeCurrent() >= end_time && TimeCurrent() < end_time+600) MyOrderClose(Slippage, magic);
}

// X^[g֐
int start()
{
   // |WV̌
   ExitPosition(MAGIC);

   // Gg[VOi̐
   int sig_entry = EntrySignal(MAGIC);

   // Gg[̃tB^[
   sig_entry = FilterSignal(sig_entry);

   // 
   if(sig_entry > 0)
   {
      MyOrderClose(Slippage, MAGIC);
      MyOrderSend(OP_BUY, Lots, Ask, Slippage, 0, 0, COMMENT, MAGIC);
   }
   // 蒍
   if(sig_entry < 0)
   {
      MyOrderClose(Slippage, MAGIC);
      MyOrderSend(OP_SELL, Lots, Bid, Slippage, 0, 0, COMMENT, MAGIC);
   }

   return(0);
}

