//+------------------------------------------------------------------+
//|                                                 Momentum1PS1.mq4 |
//|                                   Copyright (c) 2009, Toyolab FX |
//|                                         http://forex.toyolab.com |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2009, Toyolab FX"
#property link      "http://forex.toyolab.com"

// }CCu[
#include <MyLib.mqh>

// }WbNio[
#define MAGIC   20094012
#define COMMENT "Momentum1PS1"

// Op[^
extern double Leverage = 2; // obW
extern int Slippage = 3;

// bǧvZ
double CalculateLots(double leverage)
{
   string symbol = StringSubstr(Symbol(), 0, 3) + AccountCurrency();

   double conv = iClose(symbol, 0, 0);
   if(conv == 0) conv = 1;
   
   double lots = leverage * AccountFreeMargin() / 100000 / conv;

   double minlots = MarketInfo(Symbol(), MODE_MINLOT);
   double maxlots = MarketInfo(Symbol(), MODE_MAXLOT);
   int lots_digits = MathLog(1.0/minlots)/MathLog(10.0);
   lots = NormalizeDouble(lots, lots_digits);
   if(lots < minlots) lots = minlots;
   if(lots > maxlots) lots = maxlots;

   return(lots);
}

// Gg[֐
extern int MomPeriod = 20; // ^̊
int EntrySignal(int magic)
{
   // I[v|WV̌vZ
   double pos = MyCurrentOrders(MY_OPENPOS, magic);

   // ^̌vZ
   double mom1 = iMomentum(NULL, 0, MomPeriod, PRICE_CLOSE, 1);

   int ret = 0;
   // VOi
   if(pos <= 0 && mom1 > 100) ret = 1;
   // VOi
   if(pos >= 0 && mom1 < 100) ret = -1;

   return(ret);
}

// X^[g֐
int start()
{
   // bǧvZ
   double lots = CalculateLots(Leverage); 

   // Gg[VOi
   int sig_entry = EntrySignal(MAGIC);

   // 
   if(sig_entry > 0)
   {
      MyOrderClose(Slippage, MAGIC);
      MyOrderSend(OP_BUY, lots, Ask, Slippage, 0, 0, COMMENT, MAGIC);
   }
   // 蒍
   if(sig_entry < 0)
   {
      MyOrderClose(Slippage, MAGIC);
      MyOrderSend(OP_SELL, lots, Bid, Slippage, 0, 0, COMMENT, MAGIC);
   }

   return(0);
}

