//+------------------------------------------------------------------+
//|                                                        MACD1.mq4 |
//|                                   Copyright (c) 2009, Toyolab FX |
//|                                         http://forex.toyolab.com |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2009, Toyolab FX"
#property link      "http://forex.toyolab.com"

// }CCu[
#include <MyLib.mqh>

// }WbNio[
#define MAGIC   20094060
#define COMMENT "MACD1"

// Op[^
extern double Lots = 0.1;
extern int Slippage = 3;

// Gg[֐
extern int FastEMAPeriod = 12;   // ZEMÅ
extern int SlowEMAPeriod = 26;   // EMÅ
extern int SignalPeriod = 9;     // MACDSMA
int EntrySignal(int magic)
{
   // I[v|WV̌vZ
   double pos = MyCurrentOrders(MY_OPENPOS, magic);

   // MACĎvZ
   double macd1 = iMACD(NULL, 0, FastEMAPeriod, SlowEMAPeriod, SignalPeriod, PRICE_CLOSE, MODE_MAIN, 1);
   double macd2 = iMACD(NULL, 0, FastEMAPeriod, SlowEMAPeriod, SignalPeriod, PRICE_CLOSE, MODE_MAIN, 2);
   double macdsig1 = iMACD(NULL, 0, FastEMAPeriod, SlowEMAPeriod, SignalPeriod, PRICE_CLOSE, MODE_SIGNAL, 1);
   double macdsig2 = iMACD(NULL, 0, FastEMAPeriod, SlowEMAPeriod, SignalPeriod, PRICE_CLOSE, MODE_SIGNAL, 2);

   int ret = 0;
   // VOi
   if(pos <= 0 && macd2 <= macdsig2 && macd1 > macdsig1) ret = 1;
   // VOi
   if(pos >= 0 && macd2 >= macdsig2 && macd1 < macdsig1) ret = -1;

   return(ret);
}

// X^[g֐
int start()
{
   // Gg[VOi
   int sig_entry = EntrySignal(MAGIC);

   // 
   if(sig_entry > 0)
   {
      MyOrderClose(Slippage, MAGIC);
      MyOrderSend(OP_BUY, Lots, Ask, Slippage, 0, 0, COMMENT, MAGIC);
   }
   // 蒍
   if(sig_entry < 0)
   {
      MyOrderClose(Slippage, MAGIC);
      MyOrderSend(OP_SELL, Lots, Bid, Slippage, 0, 0, COMMENT, MAGIC);
   }

   return(0);
}

